<?php

declare(strict_types=1);

namespace Drupal\entity_revision_diff\Plugin\views\field;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Field handler to display the current revision ID of an entity.
 *
 * @ingroup views_field_handlers
 */
#[ViewsField("gsm_entity_current_vid")]
class EntityCurrentRevisionVID extends FieldPluginBase {

  /**
   * Constructs an EntityCurrentRevisionVID object.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function usesGroupBy(): bool {
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function query(): void {
    // Do nothing, to override the parent query.
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values): string {
    $entity = $values->_entity ?? NULL;
    if ($entity === NULL) {
      return '';
    }
    $entity_type_id = $entity->getEntityTypeId();
    $current_entity = $this->entityTypeManager->getStorage($entity_type_id)->load($entity->id());
    return (string) $current_entity?->getRevisionId();
  }

}
