<?php

declare(strict_types=1);

namespace Drupal\entity_revision_diff\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters entity revision routes to use diff-enabled forms.
 */
class EntityDiffRouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    // Get supported entity types.
    // Node is excluded as it's handled by diff module.
    $supported_types = entity_revision_diff_supported_entity_types();
    foreach (array_keys($supported_types) as $entity_type_id) {
      $route_name = "entity.{$entity_type_id}.version_history";
      if ($route = $collection->get($route_name)) {
        // Replace controller with our form that includes diff radio buttons.
        $route->setDefaults([
          '_form' => '\Drupal\entity_revision_diff\Form\EntityRevisionOverviewForm',
          '_title' => 'Revisions',
        ]);
        // Ensure entity type ID is available in route options.
        $route->setOption('entity_type_id', $entity_type_id);
        // Mark as admin route if applicable.
        if ($entity_type_id === 'group') {
          $route->setOption('_group_operation_route', TRUE);
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = parent::getSubscribedEvents();
    // Run after the Entity module's route subscriber.
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', -200];
    return $events;
  }

}
