<?php

declare(strict_types=1);

namespace Drupal\Tests\entity_revision_diff\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Base class for Entity Revision Diff functional tests.
 */
abstract class EntityRevisionDiffFunctionalTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'block',
    'block_content',
    'media',
    'taxonomy',
    'field',
    'text',
    'filter',
    'file',
    'image',
    'user',
    'entity',
    'flexible_permissions',
    'group',
    'options',
    'variationcache',
    'diff',
    'entity_revision_diff',
  ];

  /**
   * Admin user with all permissions.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    // Place required blocks.
    $this->drupalPlaceBlock('local_tasks_block');
    $this->drupalPlaceBlock('local_actions_block');
    $this->drupalPlaceBlock('page_title_block');
    $this->drupalPlaceBlock('system_messages_block');
    // Configure diff settings.
    $this->config('diff.settings')
      ->set('general_settings.layout_plugins.visual_inline.enabled', FALSE)
      ->save();
  }

  /**
   * Creates an admin user and logs in.
   *
   * @param array $additional_permissions
   *   Additional permissions to grant.
   *
   * @return \Drupal\user\UserInterface
   *   The admin user.
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  protected function loginAsAdmin(array $additional_permissions = []) {
    $permissions = [
      'administer site configuration',
      'access administration pages',
      'access block library',
      'view all group revisions',
      'revert all group revisions',
      'delete all group revisions',
      'view all block_content revisions',
      'revert all block_content revisions',
      'delete all block_content revisions',
      'view all media revisions',
      'revert all media revisions',
      'delete all media revisions',
      'view all taxonomy_term revisions',
      'revert all taxonomy_term revisions',
      'delete all taxonomy_term revisions',
      'administer group',
      'administer blocks',
      'administer media',
      'administer taxonomy',
      'view media',
    ];
    $permissions = array_merge($permissions, $additional_permissions);
    $this->adminUser = $this->drupalCreateUser($permissions);
    $this->drupalLogin($this->adminUser);
    return $this->adminUser;
  }

}
