<?php

declare(strict_types=1);

namespace Drupal\Tests\entity_revision_diff\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Base class for Entity Revision Diff kernel tests.
 */
abstract class EntityRevisionDiffKernelTestBase extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'field',
    'text',
    'filter',
    'node',
    'diff',
    'entity_revision_diff',
  ];

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(['system', 'field', 'filter', 'diff']);
    $this->installSchema('system', ['sequences']);
    $this->installEntitySchema('user');
    $this->entityTypeManager = $this->container->get('entity_type.manager');
  }

  /**
   * Gets the supported entity types from our module.
   *
   * @return array
   *   Array of entity type IDs.
   */
  protected function getSupportedEntityTypes(): array {
    return array_keys(entity_revision_diff_supported_entity_types());
  }

}
