# Entity Revision Diff Tests

This module includes comprehensive tests to ensure compatibility with Drupal core, Diff module, and Group module.

## Test Structure

```
tests/
├── src/
│   ├── Kernel/
│   │   ├── EntityRevisionDiffKernelTestBase.php   # Base class for kernel tests
│   │   ├── EntityTypeAlterTest.php             # Tests entity type alterations
│   │   ├── RouteAlterTest.php                  # Tests route modifications
│   │   ├── PermissionsTest.php                 # Tests permissions generation
│   │   └── ViewsDataTest.php                   # Tests views integration
│   ├── Functional/
│   │   ├── EntityRevisionDiffFunctionalTestBase.php  # Base class for functional tests
│   │   ├── RevisionOverviewFormTest.php        # Tests revision overview form
│   │   ├── DiffIntegrationTest.php             # Tests diff module integration
│   │   └── TranslationRevertFormTest.php       # Tests translation revert form
│   └── Unit/
│       └── EntityCurrentRevisionVIDTest.php    # Tests views field plugin
```

## What These Tests Detect

### Breaking Changes from Dependencies

1. **Diff Module Changes:**
   - `DiffRouteProvider` class location or interface changes
   - Revision diff route naming changes
   - Comparison controller changes

2. **Drupal Core Changes:**
   - Entity type handler registration API changes
   - Link template API changes
   - Route naming conventions for version_history
   - Form API changes (tables, radio buttons)
   - Permission handler API changes
   - Entity revision API changes

3. **Group Module Changes:**
   - Group entity type structure changes
   - Route structure changes

4. **Views Module Changes:**
   - Views data API changes
   - ResultRow structure changes
   - Field plugin interface changes

## Running Tests

### Prerequisites

Ensure PHPUnit is available via composer:

```bash
composer require --dev phpunit/phpunit
```

Or use Drupal's recommended test setup:

```bash
composer require --dev drupal/core-dev
```

For Kernel and Functional tests, set environment variables:

```bash
export SIMPLETEST_BASE_URL='http://localhost'
export SIMPLETEST_DB='mysql://user:pass@localhost/drupal'
```

### Running All Module Tests

```bash
cd /path/to/drupal
./vendor/bin/phpunit -c core/phpunit.xml.dist \
  modules/contrib/entity_revision_diff/tests/ --testdox
```

Or by group:

```bash
./vendor/bin/phpunit --group entity_revision_diff
```

### Running Specific Test Types

```bash
# Unit tests only (fast, no database required)
./vendor/bin/phpunit modules/contrib/entity_revision_diff/tests/src/Unit/

# Kernel tests (requires database)
./vendor/bin/phpunit -c core/phpunit.xml.dist \
  modules/contrib/entity_revision_diff/tests/src/Kernel/

# Functional tests (requires database and web server)
./vendor/bin/phpunit -c core/phpunit.xml.dist \
  modules/contrib/entity_revision_diff/tests/src/Functional/
```

### Running Specific Test Class

```bash
./vendor/bin/phpunit --filter EntityTypeAlterTest
```

## Test Coverage Summary

| Test Class | Purpose | Detects Changes In |
|------------|---------|-------------------|
| `EntityTypeAlterTest` | Verifies DiffRouteProvider and link templates | Diff module, Core entity API |
| `RouteAlterTest` | Verifies route modifications | Core routing, Diff routes |
| `PermissionsTest` | Verifies permission generation | Core permission API |
| `ViewsDataTest` | Verifies views field registration | Views API, table naming |
| `RevisionOverviewFormTest` | Verifies form rendering | Core form API, Diff JS |
| `DiffIntegrationTest` | Verifies diff comparison works | Diff module controller |
| `TranslationRevertFormTest` | Verifies translation revert | Core translation API |
| `EntityCurrentRevisionVIDTest` | Verifies views field plugin | Views plugin API |

## CI/CD Integration

### GitLab CI Example

```yaml
test:
  script:
    - composer install
    - ./vendor/bin/phpunit --group entity_revision_diff --log-junit test-results.xml
  artifacts:
    reports:
      junit: test-results.xml
```

### GitHub Actions Example

```yaml
- name: Run tests
  run: |
    ./vendor/bin/phpunit --group entity_revision_diff
  env:
    SIMPLETEST_BASE_URL: http://localhost
    SIMPLETEST_DB: sqlite://localhost/sites/default/files/.sqlite
```

## Recommended Test Frequency

- **On every commit:** Unit tests
- **On PR/MR:** Unit + Kernel tests
- **Before release:** All tests (including Functional)
- **After Drupal/module updates:** All tests
