<?php

declare(strict_types=1);

namespace Drupal\entity_splitter;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages Entity Migration plugins.
 */
class EntitySplitterManager extends DefaultPluginManager {

  /**
   * Constructs a new EntitySplitterManager instance.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/EntitySplitter', $namespaces, $module_handler, '\Drupal\\entity_splitter\\Plugin\\EntitySplitterPluginInterface', '\Drupal\\entity_splitter\\Annotation\\EntitySplitter');

    $this->alterInfo('entity_splitter_info');
    $this->setCacheBackend($cache_backend, 'entity_splitter_plugins');
  }

}
