<?php

declare(strict_types=1);

namespace Drupal\entity_splitter\Mapping;

use Drupal\Core\File\FileSystemInterface;
use Symfony\Component\Yaml\Yaml;

/**
 * Reads mapping definitions from YAML files.
 */
class YamlMappingReader {

  public function __construct(protected ?FileSystemInterface $fileSystem = NULL) {
    $this->fileSystem = \Drupal::service('file_system');
  }

  /**
   * Reads a YAML file and returns a mapping array.
   *
   * @throws \RuntimeException
   */
  public function read(string $path): array {
    if (!is_readable($path)) {
      throw new \RuntimeException(sprintf('Mapping file not readable: %s', $path));
    }
    $contents = file_get_contents($path);
    if ($contents === FALSE) {
      throw new \RuntimeException(sprintf('Could not read mapping file: %s', $path));
    }
    $data = Yaml::parse($contents);
    if (!is_array($data)) {
      throw new \RuntimeException('Invalid mapping YAML content.');
    }
    return $data;
  }

}
