# Entity Splitter

## Introduction
Entity Splitter is a Drupal module that helps you split a single source entity type/bundle into one or more target entity types/bundles. It can scaffold configuration (fields, form displays, field groups) and migrate content data, driven either by a YAML mapping file or by existing Field Group configuration. The module exposes Drush commands, a plugin system for defining split strategies, and an optional queue worker for processing data migrations asynchronously.


## Requirements
- Drupal core: 10.x or 11.x (per `core_version_requirement: ^10 || ^11`)
- PHP: As required by your Drupal 10/11 installation
- Drush: Required to run the provided CLI commands (tested with Drush 11/12)

### Dependencies
- Optional: Field Group (`field_group`) — used when deriving mappings from existing field group configuration.
- Logging channel: `entity_splitter` (provided by this module).

## Recommended modules
- Field Group — only needed if you want to auto‑derive mapping from field groups.

## Installation
There are two common ways to install custom modules:

1) Place the module in `web/modules/custom/entity_splitter` (or `modules/custom/entity_splitter` for non‑composer Drupal setups), then enable it:

```
drush en entity_splitter -y
```

2) Composer (recommended for most projects):

- This repository currently has no `composer.json` published/package name. You can add it to your project as a VCS repository in your root `composer.json` and require it by reference.

After enabling, clear caches:

```
drush cr
```

## Configuration
Entity Splitter operates through plugins. Each plugin defines:
- Source entity type and optional bundle
- Target entity type and optional target bundle entity type
- Optional bundle/field mapping rules

Plugins are annotated with `@EntitySplitter` and live under `Plugin/EntitySplitter`. See `src/Annotation/EntitySplitter.php` and `src/Plugin/EntitySplitterInterface.php` for the contract. A typical plugin extends `EntitySplitterBase` and implements any custom logic required for your site.

### Mapping sources
You can provide mapping in two ways:
- YAML mapping file: pass `--mapping-file=/path/to/mapping.yml` to commands; it is read by `YamlMappingReader`.
- Field Group mapping: pass `--use-field-groups` along with `--form-mode=...` to derive a mapping skeleton from Field Group configuration via `FieldGroupMapper`.

> Mapping YAML schema is project‑specific and not defined in this README.

## Usage
This module provides Drush commands to list available splitter plugins and to run structure/data migrations.

### List available plugins
```
drush entity-splitter:list
# Alias: drush es:list
```
This prints table rows with: ID, Label, Source entity, Source bundle, Description.

### Migrate structure (configuration scaffold)
Creates fields, reference fields, form modes, and optionally hides/removes source fields and groups.

```
drush entity-splitter:ms <plugin_id> \
  [--mapping-file=/absolute/path/to/mapping.yml] \
  [--use-field-groups] \
  [--create-fields] \
  [--create-reference-fields] \
  [--hide-source-fields] \
  [--remove-source-fields] \
  [--remove-source-field-groups] \
  [--create-new-target-form-modes] \
  [--form-mode=default] \
  [--dry-run]

# Alias: drush es:ms
```

Notes:
- `--mapping-file` reads YAML via `YamlMappingReader`.
- `--use-field-groups` instructs the mapper to derive a mapping skeleton from Field Group config for the given `--form-mode` (default `default`).
- `--create-fields` and `--create-reference-fields` control creation of field config (and reference fields on the source entity).
- `--hide-source-fields`, `--remove-source-fields`, `--remove-source-field-groups` apply changes on the source entity form display (use with care).
- `--create-new-target-form-modes` creates new form modes for target bundles (useful for Inline Entity Form setups).
- `--dry-run` avoids writing changes and only reports what would happen.

### Migrate data (content migration/splitting)
Migrates entity data from source to target per plugin logic. Can process a single entity or all, optionally via a queue.

```
drush entity-splitter:md <plugin_id> \
  [--process-all] \
  [--use-queue] \
  [--entity-id=123] \
  [--remove-existing-references]

# Alias: drush es:md
```

Notes:
- Use `--entity-id` to process only a specific entity.
- Use `--use-queue` to enqueue items for asynchronous processing (see Queue below).
- `--remove-existing-references` removes existing sub‑entity references before splitting (if your plugin supports it).

### Queue / Cron
When `--use-queue` is used with data migration, items are queued to the worker:

- Queue worker plugin ID: `entity_splitter_field_data_migration`
- Cron processing time allocation: 45 seconds (`cron: ['time' => 45]`)

Run the queue manually if needed:
```
drush queue:run entity_splitter_field_data_migration
```

### Logging
Messages are logged to the `entity_splitter` channel. Drush output includes summaries such as:

```
Plugin <id>: processed=<n>, created=<n>, updated=<n>, failed=<n> [ (dry-run) ]
```

## Environment variables
No environment variables are required by this module. If your custom plugins need environment‑specific values, manage them via Drupal configuration or your own service parameters.

## Project structure
Key files and directories:

```
entity_splitter.info.yml                  # Module info (name, description, core requirements)
entity_splitter.services.yml              # Service definitions (manager, actions, processor, mapping)
drush.services.yml                        # Drush command service wiring
src/Annotation/EntitySplitter.php         # Plugin annotation definition
src/Commands/EntitySplitterCommands.php   # Drush commands: list, migrate structure, migrate data
src/EntitySplitterActions.php             # Facade service coordinating plugins and mapping
src/EntitySplitterManager.php             # Plugin manager for Entity Splitter plugins
src/EntitySplitterResult.php              # Value object for migration summaries
src/Mapping/FieldGroupMapper.php          # Builds mapping from Field Group config
src/Mapping/YamlMappingReader.php         # Reads mapping array from YAML file
src/Plugin/EntitySplitterBase.php         # Base class for plugins (implements common logic)
src/Plugin/EntitySplitterPluginInterface.php # Plugin interface contract
src/Plugin/QueueWorker/EntitySplitterDataMigrationQueue.php # Queue worker for data migration
src/Processing/EntitySplitterProcessor.php # Core processing logic for fields, displays, and data
```

## How to define your own splitter plugin
1. Create a class under `src/Plugin/EntitySplitter` with the `@EntitySplitter` annotation. See `src/Annotation/EntitySplitter.php` for available annotation properties:
   - `id`, `label`, `description`, `source_entity_type`, `source_bundle`, `target_entity_type`, `target_bundle_entity_type`.
2. Extend `EntitySplitterBase` or implement `EntitySplitterPluginInterface` directly.
3. Implement/override:
   - `migrateStructure(array $options) : EntitySplitterResult`
   - `migrateData(array &$sandbox, array $options) : string|TranslatableMarkup`
4. Optionally implement mapping helpers (from YAML or Field Group) and ignored field groups.
5. Run via Drush using your plugin ID.

## Examples
Minimal usage examples are provided above via Drush.

## Updating from previous versions
No upgrade path notes available.

## Testing
Automated tests are not included in this repository.
- Add Kernel/Functional tests for your plugin logic and processor behavior.
- Provide sample mapping YAML fixtures for reproducible tests.

## Maintainers
Current maintainers: 
- https://www.drupal.org/u/remco-hoeneveld

## Security policy
If you discover a security issue, please do not open a public issue. Contact the maintainers privately. See current maintainers.

## Support
Please open an issue in your project tracker or Drupal.org issue queue.
- https://www.drupal.org/project/issues/entity_splitter?categories=All
