<?php

declare(strict_types=1);

namespace Drupal\entity_splitter\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an EntitySplitter plugin annotation object.
 *
 * @Annotation
 * @see \Drupal\entity_splitter\EntitySplitterManager
 */
class EntitySplitter extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The human-readable name of the migration.
   *
   * @var \Drupal\Core\StringTranslation\TranslatableMarkup|string
   */
  public TranslatableMarkup|string $label;

  /**
   * An optional description.
   *
   * @var \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   */
  public TranslatableMarkup|string|null $description;

  /**
   * The source entity-type ID (e.g. 'node').
   *
   * @var string
   */
  public string $source_entity_type;

  /**
   * The (optional) source bundle (e.g. 'article').
   *
   * @var string|null
   */
  public ?string $source_bundle;

  /**
   * The target entity type ID (e.g. 'custom_entity').
   *
   * @var string
   */
  public string $target_entity_type;

  /**
   * The (optional) target bundle (e.g. 'custom_entity_type').
   *
   * @var string|null
   */
  public ?string $target_bundle_entity_type;

}
