<?php

namespace Drupal\entity_translation_unified_form;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides a plugin manager for entity translation unified form modes.
 *
 * This class is responsible for discovering, instantiating, and managing
 * plugins for entity translation unified form modes.
 */
class EntityTranslationUnifiedFormModePluginManager extends DefaultPluginManager {

  /**
   * Constructs an EntityTranslationUnifiedFormModePluginManager object.
   *
   * @param \Traversable $namespaces
   *   The namespace iterator for plugin discovery.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend to use for plugin caching.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler for invoking hook implementations.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/EntityTranslationUnifiedFormMode',
      $namespaces,
      $module_handler,
      'Drupal\entity_translation_unified_form\EntityTranslationUnifiedFormModeInterface',
      'Drupal\entity_translation_unified_form\Annotation\EntityTranslationUnifiedFormMode'
    );

    $this->setCacheBackend($cache_backend, 'entity_translation_unified_form_plugins');
  }

}
