<?php

namespace Drupal\entity_translation_unified_form\Plugin\EntityTranslationUnifiedFormMode;

use Drupal\entity_translation_unified_form\EntityTranslationUnifiedFormModeInterface;

/**
 * Provides a tabbed mode for entity translation in forms.
 *
 * @EntityTranslationUnifiedFormMode (
 *   id = "EntityTranslationUnifiedFormTabbedMode",
 *   admin_label = @Translation("Tabbed Mode"),
 * )
 */
class EntityTranslationUnifiedFormTabbedMode extends EntityTranslationUnifiedFormInlineMode implements EntityTranslationUnifiedFormModeInterface {

  /**
   * Alters the form fields for translation in tabbed mode.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array &$field
   *   The field definition being altered.
   * @param string $field_name
   *   The name of the field.
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   */
  public function fieldFormAlter($form, $form_state, &$field, $field_name, $language) {
    if ($field_name == 'path') {
      // Path doesn't currently work well with tabs.
      // Use the inline mode for now.
      parent::alterTitle($form, $form_state, $field, $field_name, $language);
    }
  }

  /**
   * Returns the theme wrapper for the field group in tabbed mode.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array $field
   *   The field definition.
   * @param string $field_name
   *   The name of the field.
   *
   * @return string
   *   The theme wrapper name.
   */
  public function getFieldGroupThemeWrapper($form, $form_state, $field, $field_name) {
    if ($field_name == 'path') {
      // Path doesn't currently work well with tabs.
      // Use the inline wrapper for now.
      return 'entity_translation_unified_form__inline__wrapper';
    }
    return 'entity_translation_unified_form__a11y_accordion_tabs__wrapper';
  }

  /**
   * Returns the theme wrapper for a field in tabbed mode.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array $field
   *   The field definition.
   * @param string $field_name
   *   The name of the field.
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   *
   * @return string
   *   The theme wrapper name.
   */
  public function getFieldThemeWrapper($form, $form_state, $field, $field_name, $language) {
    if ($field_name == 'path') {
      // Path doesn't currently work well with tabs.
      // Use the inline wrapper for now.
      return 'entity_translation_unified_form__inline__field_wrapper';
    }
    return 'entity_translation_unified_form__a11y_accordion_tabs__field_wrapper';
  }

}
