<?php

namespace Drupal\entity_translation_unified_form\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  public function alterRoutes(RouteCollection $collection) {

    $replace_node_edit = entity_translation_unified_form_replace_any_node_edit_pages();
    if ($replace_node_edit) {
      if ($route = $collection->get('entity.node.edit_form')) {
        $route
          ->setDefaults([
            '_controller' => '\Drupal\entity_translation_unified_form\Controller\ReplacementNodeEditController::getReplacementNodeEditPage',
            '_title_callback' => '\Drupal\Core\Entity\Controller\EntityController::title',
          ]);
      }
    }
  }

}
