# INTRODUCTION

Entity Translation Unified Form allows creation of multilingual node content
on one form.

# Configuration

Visit the content language page:  
`admin/config/regional/content-language`.

Next to a content-translatable entity type, enable:  
**"Place all content-translatable fields for all enabled languages inline on
the node add/edit form".**  

When that box is checked, a new select box will appear for the 
**"Display Mode"**.

### Steps:
1. Enable **translatable** for your content type (leftmost checkbox).  
2. Check/enable **"Place all content-translatable fields for all enabled
languages inline"** on the entity add/edit form and select **"Inline Mode"**.  
3. Check/enable **"Enable side-by-side UI mode"** on the node add/edit form.  
4. **"Replace node edit"** provides equal editing capability in all languages.

Do **not** disable sync mode unless you are certain.  
Remember to also adjust **field translatability** for your content type.  

**Recommendations:**  
- Use **field groups** to organize non-translatable fields to prevent UI issues.  
- Stick with **Inline Mode** for best results.  

By default, **Inline Mode** will be selected as the **Display Mode**.  
If "Tabbed Mode" is selected, follow the requirements below.

# Display Modes

This module includes two display modes:  
1. **Inline Mode**  
2. **Tabbed Mode**  

Additional modes can be added via the Drupal **plugin system**.  
To add a mode, copy and extend a class from:  
`src/Plugin/EntityTranslationUnifiedFormMode`.

## Inline Mode

In this mode, additional language fields appear **after** the current language
field. Field titles are labeled with their language in parentheses, 
e.g., **Title (English)**.

### Inline Mode with Side-by-Side UI

To enable this mode, go to **Content Type Settings → Publishing Options**, and
enable:  
✅ **Side-by-Side UI Mode**.

For complex content types:
1. Create **two form groups** in the form display:  
   - **Details Group** (for non-translatable fields).  
   - **Sidebar Group** (for other fields).  
2. Move the **Details Group** below the translatable fields for optimal layout.  

✅ **Side-by-side mode only works at 992px and higher.**

## Tabbed Mode

This mode applies **A11Y Accordion Tabs** from:  
🔗 [GitHub: A11Y Accordion Tabs](https://github.com/matthiasott/a11y-accordion-tabs).  

Integration is adapted from the **A11Y Paragraphs Tabs** module:  
🔗 [Drupal: A11Y Paragraphs Tabs](https://www.drupal.org/project/a11y_paragraphs_tabs).

### Tabbed Mode Requirements

The **A11Y Accordion Tabs** JavaScript library must be placed in:  
`/libraries/a11y-accordion-tabs/`.

### Install Instructions:

#### Option 1: Manual Download  
1. Download the library:  
   🔗 [A11Y Accordion Tabs](https://github.com/matthiasott/a11y-accordion-tabs)  
2. Extract and rename it to **a11y-accordion-tabs**.  
3. Ensure the file path is:  
   `/libraries/a11y-accordion-tabs/a11y-accordion-tabs.js`.

#### Option 2: Composer Installation  
Add this to `composer.json` under repositories:
```
    {
        "type": "package",
        "package": {
            "name": "matthiasott/a11y-accordion-tabs",
            "version": "0.4.1",
            "dist": {
                "url": "https://github.com/matthiasott/a11y-accordion-tabs/archive/v0.4.1.zip",
                "type": "zip"
            },
            "type": "drupal-library"
        }
    },
```
Then run:  
```
composer require matthiasott/a11y-accordion-tabs
```

### Additional Requirement for Node Previews:

To enable correct preview functionality, apply this Drupal core patch:  
🔗 [Drupal Patch: Node Preview Current Language](https://www.drupal.org/files/issues/2020-06-20/node-preview_current_language-3150728-12.patch).  

Please report your results here:  
🔗 [Drupal Issue Tracker](https://www.drupal.org/i/3350693).
