<?php

namespace Drupal\entity_translation_unified_form\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Language\LanguageInterface;
use Drupal\node\Entity\Node;

/**
 * Manage functions related to "Edit Agreements" in My workspace.
 */
class ReplacementNodeEditController extends ControllerBase {

  /**
   * Displays the node creation form in a specified language.
   *
   * @param string $node
   *   The node being edited.
   *
   * @return array
   *   The node creation form as a render array.
   */
  public function getReplacementNodeEditPage(Node $node) {

    $bundle = $node->bundle();
    $replace_node_edit = entity_translation_unified_form_replace_node_edit_pages($bundle);

    if ($replace_node_edit) {
      $node_default = $node->getTranslation(LanguageInterface::LANGCODE_DEFAULT);
      $language = $node_default->language();
      $language_code = $language->getId();

      // Build the form using the entity form builder.
      $form = $this->entityFormBuilder()->getForm($node_default, 'edit', ['langcode' => $language_code]);
    }
    else {
      $form = $this->entityFormBuilder()->getForm($node, 'edit');
    }

    return $form;
  }

}
