<?php

namespace Drupal\entity_translation_unified_form;

/**
 * Defines an interface for entity translation unified form modes.
 */
interface EntityTranslationUnifiedFormModeInterface {

  /**
   * Alters the form fields for translation.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array &$field
   *   The field definition being altered.
   * @param string $field_name
   *   The name of the field.
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   */
  public function fieldFormAlter($form, $form_state, &$field, $field_name, $language);

  /**
   * Gets the theme wrapper for a field group.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array $field
   *   The field definition.
   * @param string $field_name
   *   The name of the field.
   *
   * @return string
   *   The theme wrapper name.
   */
  public function getFieldGroupThemeWrapper($form, $form_state, $field, $field_name);

  /**
   * Gets the theme wrapper for a specific field.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param array $field
   *   The field definition.
   * @param string $field_name
   *   The name of the field.
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   *
   * @return string
   *   The theme wrapper name.
   */
  public function getFieldThemeWrapper($form, $form_state, $field, $field_name, $language);

}
