<?php

declare(strict_types=1);

namespace Drupal\entity_type_behaviors\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\InterfaceType;
use GraphQL\Type\Definition\Type;

/**
 * EntityTypeBehaviorInterface GraphQL Compose Schema Type.
 *
 * @GraphQLComposeSchemaType(
 *   id = "EntityTypeBehaviorInterface",
 * )
 */
class EntityTypeBehaviorInterface extends GraphQLComposeSchemaTypeBase {

  /**
   * Returns the GraphQL types provided by this plugin.
   *
   * Defines the EntityTypeBehaviorInterface interface type with the
   * behaviorType field.
   *
   * @return array
   *   An array of GraphQL types.
   */
  public function getTypes(): array {
    return [
      new InterfaceType([
        'name' => $this->getPluginId(),
        'description' => (string) $this->t('Base interface for entity type behaviors.'),
        'fields' => fn() => [
          'behaviorType' => [
            'type' => Type::string(),
            'description' => (string) $this->t('The behavior type identifier.'),
          ],
        ],
      ]),
    ];
  }

}
