<?php

namespace Drupal\entity_usage_plus\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Form for configuring entity usage plus settings.
 *
 * @package Drupal\entity_usage_plus\Form
 */
class EntityUsagePlusSettingsForm extends ConfigFormBase {
  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'entity_usage_plus.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_usage_plus_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['override_tab_display'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Override entity usage tab display'),
      '#config_target' => new ConfigTarget(
        'entity_usage_plus.settings',
        'override_tab_display',
      ),
      '#description' => $this->t('Check this box to include child entities in the entity usage tab display. <strong>NOTE: you must clear the cache for changes to take effect.</strong>'),
    ];

    return parent::buildForm($form, $form_state);
  }

}
