<?php

namespace Drupal\entity_usage_plus\Routing;

use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\RouteCollection;

/**
 * Overrides LocalTaskUsageController.
 *
 * Note that these are dynamic routes from entity_usage module.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * Configuration factory object.
   *
   * @var \Drupal\Core\Config\ConfigFactory
   */
  protected ConfigFactory $config;

  /**
   * Constructs a new RouteSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_manager
   *   The entity type manager.
   * @param \Drupal\Core\Config\ConfigFactory $config
   *   The configuration factory object.
   */
  public function __construct(EntityTypeManagerInterface $entity_manager, ConfigFactory $config) {
    $this->entityTypeManager = $entity_manager;
    $this->config = $config;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    // If the override setting is enabled, customize the tab display.
    $override = $this->config->get('entity_usage_plus.settings')->get('override_tab_display');
    if ($override) {
      foreach ($this->entityTypeManager->getDefinitions() as $entity_type_id => $entity_type) {
        // Override the original controller with one that includes children.
        $route_name = "entity.{$entity_type_id}.entity_usage";
        if ($route = $collection->get($route_name)) {
          $route->setDefault('_controller', '\Drupal\entity_usage_plus\Controller\LocalTaskUsagePlusController::listUsageLocalTask');
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = parent::getSubscribedEvents();
    // Needs to run after entity usage's route subscriber so routes exist.
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', 98];
    return $events;
  }

}
