<?php

declare(strict_types=1);

namespace Drupal\entity_vdts\Hook;

use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\entity_vdts\EntityViewDisplayTemplateSuggestionsInterface;

/**
 * Add template suggestions.
 */
class ThemeSuggestions {

  /**
   * Implements hook_entity_view().
   *
   * Transfer data from entity view display to build array.
   */
  #[Hook('entity_view')]
  public function entityView(array &$build, EntityInterface $entity, EntityViewDisplayInterface $display, string $view_mode): void {
    $build['#' . EntityViewDisplayTemplateSuggestionsInterface::CONFIG_KEY] = $display->getThirdPartySettings(EntityViewDisplayTemplateSuggestionsInterface::CONFIG_KEY);
  }

  /**
   * Implements hook_theme_suggestions_alter().
   */
  #[Hook('theme_suggestions_alter')]
  public function themeSuggestionsAlter(array &$suggestions, array $variables, string $hook): void {
    $key = '#' . EntityViewDisplayTemplateSuggestionsInterface::CONFIG_KEY;
    if (!isset($variables['elements'][$key]) || empty($variables['elements'][$key])) {
      return;
    }

    // Currently, only bare is provided.
    if (isset($variables['elements'][$key]['bare']) && $variables['elements'][$key]['bare']) {
      if (isset($variables['theme_hook_original']) && \is_string($variables['theme_hook_original'])) {
        $suggestions[] = $variables['theme_hook_original'] . '__bare';
      }
    }
  }

}
