# Entity Group Field Lite

## Introduction

This module does the same thing as Entity Group Field, of which it is heavily inspired, but follows a slightly different approach.

## Features

This module provides a field for each defined "group - content" relationship.
For example if a user can be a member of two group types A and B you can have two fields in the user edit form, one for each group type.

- You can separately enable any of those two fields in the entity edit form.
- This module ships with a widget "Group select list" which is a simple select list.
- You can customize the displayed label of the widget for better usability and understanding.
- The select widget will automatically transform into a single checkbox if only one group is selectable.
- The widget supports multiple relationships.
- etc...

### When to use this module

- You want to have a simple select widget (with no ajax) to select the group to attach your content to.
- You have too many defined group types and/or you want to have a different field for each group type.
- You want to use a simple on/off checkbox to attach your content to a group that is unique on your project (say a private section)

### When not to use this module

- Your group relationships have fields that have to be set when adding your content to a group.

## Configuration

- On your entity form display enable the computed group field you want to expose.
- Choose the included widget "Group select list".

## Requirements

The only requirements are :

- Group (v3) obviously
- form_options_attributes used to disable non selectable options.

## Maintainers

Current maintainers for Drupal 10 / 11:

- Adel Ben Yacoub (by-adel) - https://www.drupal.org/u/by-adel
