<?php

namespace Drupal\enum_field\Plugin\views\filter;

use Drupal\enum_field\Plugin\Field\FieldType\EnumStringItem;
use Drupal\views\FieldAPIHandlerTrait;
use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\views\Plugin\views\filter\ManyToOne;
use Drupal\views\ViewExecutable;

/**
 * Filter handler which uses enum fields as options.
 *
 * @ViewsFilter("enum_field")
 */
class EnumField extends ManyToOne {

  use FieldAPIHandlerTrait;

  /**
   * {@inheritdoc}
   */
  public function init(ViewExecutable $view, DisplayPluginBase $display, ?array &$options = NULL) {
    parent::init($view, $display, $options);

    $field_storage = $this->getFieldStorageDefinition();
    // Set valueOptions here so getValueOptions() will just return it.
    $this->valueOptions = EnumStringItem::getOptions($field_storage->getSetting('enum_class'));
  }

}
