# Fast Distribution

It's an example of distributive which you can use for creating own
distributives from any Drupal site. Just prepare SQL dump and files and
switch installation profile to 'fast'.

## Installation

Download distributive and extract all files. Run command:
```
composer install
```

All dependencies will be installed with composer automatically.

Now you can install the distributive as usual Drupal site.

## Creating own distributive from Fast Distribution

1. Copy all sites/default/files/* to files/* folder in site document
root (folder with index.php file)
2. Copy all code from existing site and remove (check you are removing
files from copy):
sites/default/settings.php
sites/default/files/*
3. Copy 'fast' profile in 'profiles' folder from Fast Distribution
project.
4. Install module profile_switcher:
   https://www.drupal.org/project/profile_switcher

Change installation profile to 'fast' using Drush:
drush switch:profile fast

5. Remove existing profile/fast/dump.sql, you will need to create own dump.
6. Now, we need to prepare dump.sql from your existing site. You can use
console or Adminer/PhpMyAdmin to create dump.sql.

Console command to create a dump:
mysqldump -uuser -ppassword -hhost database > dump.sql

Adminer Evo:
https://docs.adminerevo.org/

PhpMyAdmin:
https://www.phpmyadmin.net/

Remove all commands in comments in SQL file at the beginning and at the end:
```
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
```

At the beginning you can add these queries instead:

```
SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;
```

Update collation in your dump from 
'9000_ai_ci' (default MySQL collation), 
'latin1_swedish_ci' (default MariaDB collation), 
'unicode_520_ci' (default MariaDB collation for 11.x versions) 
to 'general_ci'. 'general_ci' collation must be working for 
all mysql compatible database servers: MySQL, MariaDB, PerconaDB.
This approach allows to use PostgreSQL as well, but it will 
need separate SQL dump and selection in .profile code 
to use chosen SQL server by user.


Put you dump.sql to profiles/fast/dump.sql

7. Test you can install your installation profile as usual.


## Troubleshooting

Reach me if you have a problem or error during the process:

Ivan Abramenko
https://www.linkedin.com/in/ivan-abramenko/
https://drupal.org/u/levmyshkin
https://drupalbook.org/contact
