<?php

namespace Drupal\ept_sticky_menu\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\ept_core\Plugin\Field\FieldWidget\EptSettingsDefaultWidget;

/**
 * Plugin implementation of the 'ept_settings_sticky_menu_link' widget.
 *
 * @FieldWidget(
 *   id = "ept_settings_sticky_menu_link",
 *   label = @Translation("EPT Sticky Menu Link settings"),
 *   field_types = {
 *     "ept_settings"
 *   }
 * )
 */
class EptSettingsStickyMenuLinkWidget extends EptSettingsDefaultWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);
    unset($element['ept_settings']['design_options']);
    unset($element['ept_settings']['title_options']);

    $element['ept_settings']['open_in_new_tab'] = [
      '#title' => $this->t('Open in new tab'),
      '#type' => 'checkbox',
      '#default_value' => $items[$delta]->ept_settings['open_in_new_tab'] ?? 0,
    ];

    $element['ept_settings']['link_classes'] = [
      '#title' => $this->t('Link Classes'),
      '#type' => 'textfield',
      '#default_value' => $items[$delta]->ept_settings['link_classes'] ?? '',
    ];

    $element['ept_settings']['rel'] = [
      '#title' => $this->t('Rel attribute'),
      '#type' => 'radios',
      '#options' => [
        '' => $this->t('- None -'),
        'nofollow' => $this->t('nofollow'),
      ],
      '#default_value' => $items[$delta]->ept_settings['mode'] ?? ''
    ];

    $element['ept_settings']['scroll_to_id'] = [
      '#title' => $this->t('Scroll to ID'),
      '#type' => 'textfield',
      '#default_value' => $items[$delta]->ept_settings['scroll_to_id'] ?? '',
    ];

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    foreach ($values as &$value) {
      $value += ['ept_settings' => []];
    }
    return $values;
  }

}
