<?php

namespace Drupal\ept_sticky_menu\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\ept_core\Plugin\Field\FieldWidget\EptSettingsDefaultWidget;

/**
 * Plugin implementation of the 'ept_settings_sticky_menu' widget.
 *
 * @FieldWidget(
 *   id = "ept_settings_sticky_menu",
 *   label = @Translation("EPT Sticky Menu settings"),
 *   field_types = {
 *     "ept_settings"
 *   }
 * )
 */
class EptSettingsStickyMenuWidget extends EptSettingsDefaultWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $element['ept_settings']['pass_options_to_javascript'] = [
      '#type' => 'hidden',
      '#value' => TRUE,
    ];

    $element['ept_settings']['design_options']['#weight'] = -32;

    $element['ept_settings']['enable_sticky'] = [
      '#title' => $this->t('Enable sticky functionality'),
      '#type' => 'checkbox',
      '#default_value' => $items[$delta]->ept_settings['enable_sticky'] ?? 1,
      '#description' => $this->t('Make menu sticky on scroll'),
    ];

    // @todo Select menu to display in paragraph.

    $element['ept_settings']['margin_top'] = [
      '#title' => $this->t('Margin top'),
      '#type' => 'number',
      '#default_value' => $items[$delta]->ept_settings['margin_top'] ?? 0,
      '#description' => $this->t('Margin between page and sticky element when scrolled'),
    ];

    $element['ept_settings']['sticky_for'] = [
      '#title' => $this->t('Sticky for'),
      '#type' => 'number',
      '#default_value' => $items[$delta]->ept_settings['sticky_for'] ?? 0,
      '#description' => $this->t('Breakpoint which when is bigger than viewport width, sticky is activated and when is smaller, then sticky is destroyed'),
    ];

    $element['ept_settings']['sticky_class'] = [
      '#title' => $this->t('Sticky class'),
      '#type' => 'number',
      '#default_value' => $items[$delta]->ept_settings['sticky_class'] ?? 'is-sticky',
      '#description' => $this->t('Class added to sticky element when it is stuck'),
    ];

    $element['ept_settings']['sticky_wrap'] = [
      '#title' => $this->t('Sticky wrap'),
      '#type' => 'checkbox',
      '#default_value' => $items[$delta]->ept_settings['sticky_wrap'] ?? 0,
      '#description' => $this->t('When it\'s true sticky element is wrapped in <span></span> which has sticky element dimensions. Prevents content from "jumping".'),
    ];

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    foreach ($values as &$value) {
      $value += ['ept_settings' => []];
    }
    return $values;
  }

}
