<?php

namespace Drupal\es_attachment\Plugin\search_api_attachments;

use Drupal\Core\Form\FormStateInterface;
use Drupal\file\Entity\File;
use Drupal\search_api_attachments\TextExtractorPluginBase;

/**
 * Provides ElasticSearch Pipeline extractor.
 *
 * @SearchApiAttachmentsTextExtractor(
 *   id = "es_pipeline_extractor",
 *   label = @Translation("ElasticSearch Pipeline Extractor"),
 *   description = @Translation("Use ElasticSearch pipeline attachment."),
 * )
 */
class EsPipelineExtractor extends TextExtractorPluginBase {

  /**
   * {@inheritdoc}
   */
  public function extract(File $file) {
    $path = $file->getFileUri();
    // If path is not set, do nothing.
    if (!isset($path) && empty($path)) {
      // @todo Handle this exception better.
      return '';
    }

    // Load and Encode the file contents.
    $data = file_get_contents($path);
    // @todo Crypt::hashBase64 doesn't seem to work with Elasticsearch.
    // Reverting back to base64_encode().
    $base64 = base64_encode($data);

    // Return the base64 encoded file.
    // @todo Check performance impact with larger files.
    return $base64;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['ES_attachment'] = [
      '#markup' => $this->t('No config needed'),
    ];
    return $form;
  }

}
