<?php

namespace Drupal\es_filter_analyser\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Analyser entities.
 */
interface AnalyserInterface extends ConfigEntityInterface {

  /**
   * Gets the tokenizer.
   *
   * @return string
   *   The tokenizer.
   */
  public function getTokenizer();

  /**
   * Sets the tokenizer.
   *
   * @param string $tokenizer
   *   The tokenizer.
   *
   * @return $this
   */
  public function setTokenizer($tokenizer);

  /**
   * Gets the filters.
   *
   * @return array
   *   The filters with their weights.
   */
  public function getFilters();

  /**
   * Sets the filters.
   *
   * @param array $filters
   *   The filters with their weights.
   *
   * @return $this
   */
  public function setFilters(array $filters);


}
