<?php

namespace Drupal\es_filter_analyser\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Filter entities.
 */
interface FilterInterface extends ConfigEntityInterface {

  /**
   * Gets the filter type.
   *
   * @return string
   *   The filter type.
   */
  public function getType();

  /**
   * Sets the filter type.
   *
   * @param string $type
   *   The filter type.
   *
   * @return $this
   */
  public function setType($type);

  /**
   * Gets the filter settings.
   *
   * @return array
   *   The filter settings.
   */
  public function getSettings();

  /**
   * Sets the filter settings.
   *
   * @param array $settings
   *   The filter settings.
   *
   * @return $this
   */
  public function setSettings(array $settings);

}
