<?php

namespace Drupal\es_filter_analyser\EventSubscriber;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\elasticsearch_connector\Event\QueryParamsEvent;
use Drupal\es_filter_analyser\EventSubscriberBase;

/**
 * Event subscriber for Elasticsearch query parameters.
 */
class AddGlobalSearchAnalyserInQuery extends EventSubscriberBase {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a FunctionScoreQuerySubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      QueryParamsEvent::class => 'addSearchAnalyser',
    ];
  }

  /**
   * Reacts to the QueryParamsEvent.
   *
   * @param \Drupal\elasticsearch_connector\Event\QueryParamsEvent $event
   *   The event object.
   */
  public function addSearchAnalyser(QueryParamsEvent $event) {
    $params = $event->getParams();

    $query = $event->getQuery();

    // 1. get Processor Settings
    $processor_config = $this->getProcessorSettings($query->getIndex(), 'analyser_processor');
    if ($processor_config == NULL) {
      return;
    }

    // 2. Check if global search analyser is used.
    $global_search_analyser = $processor_config['global_search_analyser'];
    if ($global_search_analyser == NULL) {
      return;
    }

    if(!isset($params['body']['query'])) {
      return;
    }

    // 3. Set analyser in query.
    $key = array_key_first($params['body']['query']);

    if ($key == 'multi_match' || $key == 'query_string') {
      $params['body']['query'][$key]['analyzer'] = $global_search_analyser;
    }
    elseif ($key == 'match') {
      // First key of match can be the fieldname.
      $field_name = array_key_first($params['body']['query']['match']);
      $params['body']['query']['match'][$field_name]['analyzer'] = $global_search_analyser;
    }

    $event->setParams($params);
  }

}
