<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a CJK Bigram filter type.
 *
 * @FilterType(
 *   id = "cjk_bigram",
 *   label = @Translation("CJK Bigram"),
 *   description = @Translation("Forms bigrams from CJK tokens.")
 * )
 */
class CjkBigram extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'ignored_scripts' => [],
      'output_unigrams' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['ignored_scripts'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Ignored scripts'),
      '#options' => [
        'han' => $this->t('Han (Chinese)'),
        'hiragana' => $this->t('Hiragana (Japanese)'),
        'katakana' => $this->t('Katakana (Japanese)'),
        'hangul' => $this->t('Hangul (Korean)'),
      ],
      '#default_value' => $configuration['ignored_scripts'],
      '#description' => $this->t('Scripts to ignore when forming bigrams.'),
    ];

    $form['output_unigrams'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Output unigrams'),
      '#default_value' => $configuration['output_unigrams'],
      '#description' => $this->t('If checked, outputs individual characters as well as bigrams.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $ignored_scripts = array_filter($values['ignored_scripts']);

    return [
      'ignored_scripts' => array_values($ignored_scripts),
      'output_unigrams' => (bool) $values['output_unigrams'],
    ];
  }

}
