<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a CJK Width filter type.
 *
 * @FilterType(
 *   id = "cjk_width",
 *   label = @Translation("CJK Width"),
 *   description = @Translation("Normalizes width differences in CJK characters.")
 * )
 */
class CjkWidth extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It normalizes full-width and half-width CJK characters.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
