<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Decimal Digit filter type.
 *
 * @FilterType(
 *   id = "decimal_digit",
 *   label = @Translation("Decimal Digit"),
 *   description = @Translation("Converts all Unicode decimal digits to 0-9.")
 * )
 */
class DecimalDigit extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It converts all Unicode decimal digits to their ASCII equivalents (0-9).'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
