<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Fingerprint filter type.
 *
 * @FilterType(
 *   id = "fingerprint",
 *   label = @Translation("Fingerprint"),
 *   description = @Translation("Creates a fingerprint for duplicate detection.")
 * )
 */
class Fingerprint extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'max_output_size' => 255,
      'separator' => ' ',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['max_output_size'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum output size'),
      '#default_value' => $configuration['max_output_size'],
      '#description' => $this->t('Maximum size of the output token.'),
      '#required' => TRUE,
      '#min' => 1,
    ];

    $form['separator'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Separator'),
      '#default_value' => $configuration['separator'],
      '#description' => $this->t('Character to use as separator.'),
      '#required' => TRUE,
      '#maxlength' => 1,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'separator' => $values['separator'],
      'max_output_size' => (int) $values['max_output_size'],
    ];
  }

}
