<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a KStem filter type.
 *
 * @FilterType(
 *   id = "kstem",
 *   label = @Translation("KStem"),
 *   description = @Translation("Provides high-quality stemming for English with less aggressive stemming than Porter.")
 * )
 */
class KStem extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It provides less aggressive stemming for English.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
