<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Keep filter type.
 *
 * @FilterType(
 *   id = "keep",
 *   label = @Translation("Keep"),
 *   description = @Translation("Keeps only tokens that match specified words.")
 * )
 */
class Keep extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'keep_words' => [],
      'keep_words_case' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['keep_words'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Keep words'),
      '#default_value' => implode("\n", $configuration['keep_words']),
      '#description' => $this->t('Enter one word per line. Only these words will be kept.'),
      '#required' => TRUE,
      '#rows' => 10,
    ];

    $form['keep_words_case'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Case sensitive'),
      '#default_value' => $configuration['keep_words_case'],
      '#description' => $this->t('If checked, matching is case-sensitive.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $keep_words = $values['keep_words'];
    $keep_words_array = array_filter(array_map('trim', explode("\n", $keep_words)));

    return [
      'keep_words' => array_values($keep_words_array),
      'keep_words_case' => (bool) $values['keep_words_case'],
    ];
  }

}
