<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Keep Types filter type.
 *
 * @FilterType(
 *   id = "keep_types",
 *   label = @Translation("Keep Types"),
 *   description = @Translation("Keeps only tokens of specified types.")
 * )
 */
class KeepTypes extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'types' => ['<NUM>', '<ALPHANUM>'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['types'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Token types'),
      '#default_value' => implode("\n", $configuration['types']),
      '#description' => $this->t('Enter one token type per line (e.g., &lt;NUM&gt;, &lt;ALPHANUM&gt;).'),
      '#required' => TRUE,
      '#rows' => 5,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $types = $values['types'];
    $types_array = array_filter(array_map('trim', explode("\n", $types)));

    return [
      'types' => array_values($types_array),
      'mode' => $values['mode'],
    ];
  }

}
