<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Keyword Marker filter type.
 *
 * @FilterType(
 *   id = "keyword_marker",
 *   label = @Translation("Keyword Marker"),
 *   description = @Translation("Protects words from being modified by stemmers.")
 * )
 */
class KeywordMarker extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'keywords' => [],
      'ignore_case' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['keywords'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Keywords'),
      '#default_value' => implode("\n", $configuration['keywords']),
      '#description' => $this->t('Enter one keyword per line. These words will be protected from stemming.'),
      '#required' => TRUE,
      '#rows' => 10,
    ];

    $form['ignore_case'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Ignore case'),
      '#default_value' => $configuration['ignore_case'],
      '#description' => $this->t('If checked, matching is case-insensitive.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $keywords = $values['keywords'];
    $keywords_array = array_filter(array_map('trim', explode("\n", $keywords)));

    return [
      'keywords' => array_values($keywords_array),
      'ignore_case' => (bool) $values['ignore_case'],
    ];
  }

}
