<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Lowercase filter type.
 *
 * @FilterType(
 *   id = "lowercase",
 *   label = @Translation("Lowercase"),
 *   description = @Translation("Converts tokens to lowercase.")
 * )
 */
class Lowercase extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It simply converts all tokens to lowercase.'),
    ];
    return $form;
  }

}
