<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Porter Stem filter type.
 *
 * @FilterType(
 *   id = "porter_stem",
 *   label = @Translation("Porter Stem"),
 *   description = @Translation("Provides algorithmic stemming for English based on the Porter stemming algorithm.")
 * )
 */
class PorterStem extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It applies the Porter stemming algorithm for English.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
