<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Remove Duplicates filter type.
 *
 * @FilterType(
 *   id = "remove_duplicates",
 *   label = @Translation("Remove Duplicates"),
 *   description = @Translation("Removes duplicate consecutive tokens.")
 * )
 */
class RemoveDuplicates extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It removes duplicate consecutive tokens.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
