<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Stemmer filter type.
 *
 * @FilterType(
 *   id = "stemmer",
 *   label = @Translation("Stemmer"),
 *   description = @Translation("Reduces words to their root form.")
 * )
 */
class Stemmer extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'language' => 'english',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['language'] = [
      '#type' => 'select',
      '#title' => $this->t('Language'),
      '#default_value' => $configuration['language'],
      '#options' => [
        'arabic' => $this->t('Arabic'),
        'armenian' => $this->t('Armenian'),
        'basque' => $this->t('Basque'),
        'bengali' => $this->t('Bengali'),
        'brazilian' => $this->t('Brazilian Portuguese'),
        'bulgarian' => $this->t('Bulgarian'),
        'catalan' => $this->t('Catalan'),
        'czech' => $this->t('Czech'),
        'danish' => $this->t('Danish'),
        'dutch' => $this->t('Dutch'),
        'english' => $this->t('English'),
        'light_english' => $this->t('Light English'),
        'finnish' => $this->t('Finnish'),
        'french' => $this->t('French'),
        'light_french' => $this->t('Light French'),
        'galician' => $this->t('Galician'),
        'german' => $this->t('German'),
        'light_german' => $this->t('Light German'),
        'greek' => $this->t('Greek'),
        'hindi' => $this->t('Hindi'),
        'hungarian' => $this->t('Hungarian'),
        'indonesian' => $this->t('Indonesian'),
        'irish' => $this->t('Irish'),
        'italian' => $this->t('Italian'),
        'light_italian' => $this->t('Light Italian'),
        'latvian' => $this->t('Latvian'),
        'lithuanian' => $this->t('Lithuanian'),
        'norwegian' => $this->t('Norwegian'),
        'light_norwegian' => $this->t('Light Norwegian'),
        'portuguese' => $this->t('Portuguese'),
        'light_portuguese' => $this->t('Light Portuguese'),
        'romanian' => $this->t('Romanian'),
        'russian' => $this->t('Russian'),
        'light_russian' => $this->t('Light Russian'),
        'spanish' => $this->t('Spanish'),
        'light_spanish' => $this->t('Light Spanish'),
        'swedish' => $this->t('Swedish'),
        'light_swedish' => $this->t('Light Swedish'),
        'turkish' => $this->t('Turkish'),
      ],
      '#required' => TRUE,
      '#description' => $this->t('Select the language for stemming.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {

    return [
      'language' => $values['language'],
    ];
  }

}
