<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Stop filter type.
 *
 * @FilterType(
 *   id = "stop",
 *   label = @Translation("Stop"),
 *   description = @Translation("Removes stop words from token stream.")
 * )
 */
class Stop extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'stopwords' => '_english_',
      'ignore_case' => FALSE,
      'remove_trailing' => TRUE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['stopwords'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Stopwords'),
      '#default_value' => $configuration['stopwords'],
      '#description' => $this->t('Predefined list (e.g., _english_, _french_) or custom comma-separated words.'),
      '#required' => TRUE,
    ];

    $form['ignore_case'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Ignore case'),
      '#default_value' => $configuration['ignore_case'],
      '#description' => $this->t('If checked, stopwords matching is case-insensitive.'),
    ];

    $form['remove_trailing'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Remove trailing'),
      '#default_value' => $configuration['remove_trailing'],
      '#description' => $this->t('If checked, the last token is removed if it is a stop word.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $stopwords = $values['stopwords'];
    $stopwords_array = array_filter(array_map('trim', explode("\n", $stopwords)));

    return [
      'stopwords' => array_values($stopwords_array),
      'ignore_case' => (bool) $values['ignore_case'],
      'remove_trailing' => (bool) $values['remove_trailing'],
    ];
  }

}
