<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Synonym filter type.
 *
 * @FilterType(
 *   id = "synonym",
 *   label = @Translation("Synonym"),
 *   description = @Translation("Handles synonyms during analysis.")
 * )
 */
class Synonym extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'synonyms' => [],
      'expand' => TRUE,
      'lenient' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['synonyms'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Synonyms'),
      '#default_value' => implode("\n", $configuration['synonyms']),
      '#description' => $this->t('Enter one synonym rule per line. Format: "word1, word2, word3" or "word1 => word2".'),
      '#required' => TRUE,
      '#rows' => 10,
    ];

    $form['expand'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Expand'),
      '#default_value' => $configuration['expand'],
      '#description' => $this->t('If checked, all synonyms are expanded. If unchecked, only the first synonym is kept.'),
    ];

    $form['lenient'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Lenient'),
      '#default_value' => $configuration['lenient'],
      '#description' => $this->t('If checked, ignores exceptions while parsing synonym rules.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $synonyms = $values['synonyms'];
    $synonyms_array = array_filter(array_map('trim', explode("\n", $synonyms)));

    return [
      'synonyms' => array_values($synonyms_array),
      'expand' => (bool) $values['expand'],
      'lenient' => (bool) $values['lenient'],
    ];
  }

}
