<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Truncate filter type.
 *
 * @FilterType(
 *   id = "truncate",
 *   label = @Translation("Truncate"),
 *   description = @Translation("Truncates tokens to a specified length.")
 * )
 */
class Truncate extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'length' => 10,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['length'] = [
      '#type' => 'number',
      '#title' => $this->t('Length'),
      '#default_value' => $configuration['length'],
      '#description' => $this->t('Maximum length of tokens.'),
      '#required' => TRUE,
      '#min' => 1,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'length' => (int) $values['length'],
    ];
  }

}
