<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Unique filter type.
 *
 * @FilterType(
 *   id = "unique",
 *   label = @Translation("Unique"),
 *   description = @Translation("Removes duplicate tokens in the same position.")
 * )
 */
class Unique extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'only_on_same_position' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['only_on_same_position'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Only on same position'),
      '#default_value' => $configuration['only_on_same_position'],
      '#description' => $this->t('If checked, only removes duplicates at the same position.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'only_on_same_position' => (bool) $values['only_on_same_position'],
    ];
  }

}
