<?php

namespace Drupal\es_filter_analyser;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Analyser entities.
 */
class AnalyserListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Analyser');
    $header['id'] = $this->t('Machine name');
    $header['tokenizer'] = $this->t('Tokenizer');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\es_filter_analyser\Entity\AnalyserInterface $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['tokenizer'] = $entity->getTokenizer();
    return $row + parent::buildRow($entity);
  }

}
