<?php

namespace Drupal\es_filter_analyser\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Filter Type annotation object.
 *
 * @Annotation
 */
class FilterType extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the filter type.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the filter type.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

}
