<?php

namespace Drupal\es_filter_analyser\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Analyser entity.
 *
 * @ConfigEntityType(
 *   id = "es_analyser",
 *   label = @Translation("ElasticSearch Analyser"),
 *   label_collection = @Translation("ElasticSearch Analysers"),
 *   label_singular = @Translation("ElasticSearch analyser"),
 *   label_plural = @Translation("ElasticSearch analysers"),
 *   label_count = @PluralTranslation(
 *     singular = "@count analyser",
 *     plural = "@count analysers",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\es_filter_analyser\AnalyserListBuilder",
 *     "form" = {
 *       "add" = "Drupal\es_filter_analyser\Form\AnalyserForm",
 *       "edit" = "Drupal\es_filter_analyser\Form\AnalyserForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "analyser",
 *   admin_permission = "administer es_filter_analyser",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "canonical" = "/admin/config/search/analyser/{es_analyser}",
 *     "add-form" = "/admin/config/search/analyser/add",
 *     "edit-form" = "/admin/config/search/analyser/{es_analyser}/edit",
 *     "delete-form" = "/admin/config/search/analyser/{es_analyser}/delete",
 *     "collection" = "/admin/config/search/analyser"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "tokenizer",
 *     "filters",
 *   }
 * )
 */
class Analyser extends ConfigEntityBase implements AnalyserInterface {

  /**
   * The Analyser ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Analyser label.
   *
   * @var string
   */
  protected $label;

  /**
   * The tokenizer.
   *
   * @var string
   */
  protected $tokenizer;

  /**
   * The filters (array of filter entity IDs with weights).
   *
   * @var array
   */
  protected $filters = [];

  /**
   * {@inheritdoc}
   */
  public function getTokenizer() {
    return $this->tokenizer;
  }

  /**
   * {@inheritdoc}
   */
  public function setTokenizer($tokenizer) {
    $this->tokenizer = $tokenizer;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getFilters() {
    return (is_array($this->filters)) ? $this->filters : [];
  }

  /**
   * {@inheritdoc}
   */
  public function setFilters(array $filters) {
    $this->filters = $filters;
    return $this;
  }

  /**
   * Return Analyser data formated to be send to ES.
   *
   * @return array
   *   Formated data for ES.
   */
  public function getConfigData() {
    return [
      'tokenizer' => $this->getTokenizer(),
      'filter' => $this->getFilters(),
    ];
  }

}
