<?php

namespace Drupal\es_filter_analyser\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Filter entity.
 *
 * @ConfigEntityType(
 *   id = "es_filter",
 *   label = @Translation("ElasticSearch Filter"),
 *   label_collection = @Translation("ElasticSearch Filters"),
 *   label_singular = @Translation("ElasticSearch filter"),
 *   label_plural = @Translation("ElasticSearch filters"),
 *   label_count = @PluralTranslation(
 *     singular = "@count filter",
 *     plural = "@count filters",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\es_filter_analyser\FilterListBuilder",
 *     "form" = {
 *       "add" = "Drupal\es_filter_analyser\Form\FilterForm",
 *       "edit" = "Drupal\es_filter_analyser\Form\FilterForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "filter",
 *   admin_permission = "administer es_filter_analyser",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "canonical" = "/admin/config/search/filter/{es_filter}",
 *     "add-form" = "/admin/config/search/filter/add",
 *     "edit-form" = "/admin/config/search/filter/{es_filter}/edit",
 *     "delete-form" = "/admin/config/search/filter/{es_filter}/delete",
 *     "collection" = "/admin/config/search/filter"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "type",
 *     "settings",
 *   }
 * )
 */
class Filter extends ConfigEntityBase implements FilterInterface {

  /**
   * The Filter ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Filter label.
   *
   * @var string
   */
  protected $label;

  /**
   * The filter type.
   *
   * @var string
   */
  protected $type;

  /**
   * The filter settings.
   *
   * @var array
   */
  protected $settings = [];

  /**
   * {@inheritdoc}
   */
  public function getType() {
    return $this->type;
  }

  /**
   * {@inheritdoc}
   */
  public function setType($type) {
    $this->type = $type;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getSettings() {
    return $this->settings;
  }

  /**
   * {@inheritdoc}
   */
  public function setSettings(array $settings) {
    $this->settings = $settings;
    return $this;
  }

  /**
   * Return Filter data formated to be send to ES.
   *
   * @return array
   *   Formated data for ES.
   */
  public function getConfigData() {

    $data = $this->get('settings');
    $data['type'] = $this->get('type');
    return $data;
  }

}
