<?php

namespace Drupal\es_filter_analyser\EventSubscriber;

use Drupal\elasticsearch_connector\Event\FieldMappingEvent;
use Drupal\es_filter_analyser\EventSubscriberBase;

/**
 * Event subscriber for Elasticsearch query parameters.
 */
class AddAnalyserInFields extends EventSubscriberBase {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      FieldMappingEvent::class => 'fieldMappingEvent',
    ];
  }

  /**
   * Reacts to the FieldMappingEvent.
   *
   * @param \Drupal\elasticsearch_connector\Event\FieldMappingEvent $event
   *   The event object.
   */
  public function fieldMappingEvent(FieldMappingEvent $event) {

    $processor_config = $this->getProcessorSettings($event->getField()->getIndex(), 'analyser_processor');
    $params = $event->getParam();
    $field = $event->getField();
    $field_name = $field->getFieldIdentifier();

    if (isset($processor_config['field_analysers'][$field_name])) {

      $field_conf = $processor_config['field_analysers'][$field_name];
      if (isset($field_conf['index_analyser']) && $field_conf['index_analyser'] != '') {
        $params['analyzer'] = $field_conf['index_analyser'];
      }
      if (isset($field_conf['search_analyser']) && $field_conf['search_analyser'] != '') {
        $params['search_analyzer'] = $field_conf['search_analyser'];
      }

      $event->setParam($params);
    }
  }

}
