<?php

namespace Drupal\es_filter_analyser\EventSubscriber;

use Drupal\elasticsearch_connector\Event\AlterSettingsEvent;
use Drupal\es_filter_analyser\EventSubscriberBase;

/**
 * Event subscriber for Elasticsearch query parameters.
 */
class AddAnalyserInIndex extends EventSubscriberBase {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    // Be sure pass AFTER elacsticSearch Connector.
    return [
      AlterSettingsEvent::class => 'alterSettingsEvent',
    ];
  }

  /**
   * Reacts to the AlterSettingsEvent.
   *
   * @param \Drupal\elasticsearch_connector\Event\AlterSettingsEvent $event
   *   The event object.
   */
  public function alterSettingsEvent(AlterSettingsEvent $event) {

    // 1. get Processor Settings
    $processor_config = $this->getProcessorSettings($event->getIndex(), 'analyser_processor');
    if ($processor_config == NULL) {
      return;
    }

    // 2. Get all Analysers.
    $analysers = [];
    foreach ($processor_config['field_analysers'] as $data) {
      if (!in_array($data['index_analyser'], $analysers)) {
        $analysers[] = $data['index_analyser'];
      }
      if (!in_array($data['search_analyser'], $analysers)) {
        $analysers[] = $data['index_analyser'];
      }
    }

    if (count($analysers) == 0) {
      return;
    }

    // 3. Get All filters.
    $analysers_storage = $this->entityTypeManager->getStorage('es_analyser');
    $analysers_entity = $analysers_storage->loadMultiple($analysers);

    $filters = [];
    foreach ($analysers_entity as $analyser) {

      $filters_item = $analyser->get('filters');
      foreach ($filters_item as $filter_key) {
        if (!in_array($filter_key, $filters)) {
          $filters[] = $filter_key;
        }
      }

    }
    if (count($filters) == 0) {
      return;
    }

    // 4. set Filters
    $filter_storage = $this->entityTypeManager->getStorage('es_filter');
    $filers_entity = $filter_storage->loadMultiple($filters);

    $settings = $event->getSettings();

    if (!isset($settings['analysis']['filter'])) {
      $settings['analysis']['filter'] = [];
    }
    foreach ($filers_entity as $filter_key => $filter) {
      $settings['analysis']['filter'][$filter_key] = $filter->getConfigData();
    }

    // 5. Set Analysers
    if (!isset($settings['analysis']['analyzer'])) {
      $settings['analysis']['analyzer'] = [];
    }
    foreach ($analysers_entity as $analyser_key => $analyser) {
      $settings['analysis']['analyzer'][$analyser_key] = $analyser->getConfigData();
    }

    $event->setSettings($settings);
  }

}
